% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{decodeCDT}
\alias{decodeCDT}
\title{Converts a complete derivation tree into a program.}
\usage{
decodeCDT(tree, ST)
}
\arguments{
\item{tree}{Derivation tree.}

\item{ST}{Symbol table.}
}
\value{
A program.
}
\description{
\code{decodeCDT()} returns a program
             (a text string with the terminal symbol string).
             If the derivation tree still has non-terminal leaves,
             the non-terminal leaves are omitted.
             The program produces a syntax error.
             The program can not be repaired.
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
decodeCDT(a, g$ST) 

}
\seealso{
Other Decoder: 
\code{\link{decodeAndFixDT}()},
\code{\link{decodeDT}()},
\code{\link{decodeDTsym}()},
\code{\link{decodeTree}()},
\code{\link{leavesIncompleteDT}()}
}
\concept{Decoder}
