% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNFdiag.R
\name{printPT}
\alias{printPT}
\title{Print a production table of a grammar.}
\usage{
printPT(PT, G, verbose = TRUE)
}
\arguments{
\item{PT}{A production table of the grammar G.}

\item{G}{A grammar object}

\item{verbose}{Print production table? Default: \code{TRUE}.}
}
\value{
An invisible list of the production table.
}
\description{
Print a production table of a grammar.
}
\examples{
g<-compileBNF(booleanGrammar())
cat("Production table:\n")
l<-printPT(g$PT, g, verbose=TRUE)
cat("Short Production table:\n")
printPT(g$SPT, g, verbose=TRUE)

}
\seealso{
Other Diagnostics: 
\code{\link{dataframePT}()}
}
\concept{Diagnostics}
