% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcEADRegulatory.R
\name{calcEADRegulatory}
\alias{calcEADRegulatory}
\title{Calculates the Exposure-At-Default (EAD)}
\usage{
calcEADRegulatory(
  trades,
  framework,
  sa_ccr_simplified = "",
  CSA,
  collateral,
  EEE,
  time_points
)
}
\arguments{
\item{trades}{The full list of the Trade Objects}

\item{framework}{Specifies the regulatory framework used in the calculations. It can take the values of 'IMM', 'CEM', 'SA-CCR'}

\item{sa_ccr_simplified}{(Optional) Specifies whether the standard SACCR or its simplified version or the OEM will be implemented. It can take the values of '', 'simplified', 'OEM'}

\item{CSA}{The margin agreement with the counterparty}

\item{collateral}{The amount of collaterals currently exchanged with the counterparty}

\item{EEE}{A vector containing the effective expected exposure against the counterparty}

\item{time_points}{The timepoints that the analysis is performed on}
}
\value{
The Exposure-At-Default
}
\description{
Calculates the Exposure-At-Default (EAD) based on the given regulatory framework. It supports the CEM, IMM and (simplified) SA-CCR frameworks
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
