% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MClav_StdRAM2.R
\name{StdRAM2}
\alias{StdRAM2}
\title{Standardize RAM Matrices}
\usage{
StdRAM2(ram_est)
}
\arguments{
\item{ram_est}{A RAM object list with matrices \code{A}, \code{S}, \code{F}, and \code{M} as returned by \code{Lav2RAM2()}.}
}
\value{
A list of standardized RAM matrices:
\describe{
\item{A}{Standardized asymmetric path matrix}
\item{S}{Standardized symmetric path matrix}
\item{F}{Unchanged filter matrix}
\item{M}{Standardized intercept vector}
}
}
\description{
Performs standardization of RAM matrices by rescaling path and variance structures
using the implied covariance matrix. Intercepts are also standardized.
}
\details{
The function computes the implied covariance matrix \eqn{\Sigma = (I - A)^{-1} S (I - A)^{-T}},
extracts standard deviations, and performs standardization via \eqn{D^{-1}} scaling.
}
\keyword{internal}
