% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewt.R
\name{EWT}
\alias{EWT}
\title{Expected win time}
\usage{
EWT(
  m,
  dist_state0,
  dist_state1,
  unique_event_times0,
  unique_event_times1,
  nunique_event_times0,
  nunique_event_times1
)
}
\arguments{
\item{m}{The number of events in the hierarchy.}

\item{dist_state0}{A matrix of control arm state probabilities (returned from wintime::km() or wintime::markov()).}

\item{dist_state1}{A matrix of treatment arm state probabilities (returned from wintime::km() or wintime::markov()).}

\item{unique_event_times0}{A vector of unique control arm event times (days) (returned from wintime::km() or wintime::markov()).}

\item{unique_event_times1}{A vector of unique treatment arm event times (days) (returned from wintime::km() or wintime::markov()).}

\item{nunique_event_times0}{The number of unique control arm event times (returned from wintime::km() or wintime::markov()).}

\item{nunique_event_times1}{The number of unique treatment arm event times (returned from wintime::km() or wintime::markov()).}
}
\value{
A list of the expected win time of the treatment arm, the components of the treatment effect.
}
\description{
Calculates the state space probabilities using a Kaplan-Meier model (recommended) or a Markov model. This function uses these probabilities
to compare both arms and calculate the expected win time of the treatment arm.
}
