% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_mappings.R
\docType{data}
\name{items_prod}
\alias{items_prod}
\title{Primary production items}
\format{
A tibble where each row corresponds to one production item.
It contains the following columns:
\itemize{
\item \code{item_prod_code}: A numeric code used to refer to the item.
\item \code{item_prod_name}: A natural language name for the item.
\item \code{item_type}: An ad-hoc grouping of items. This is a work in progress
evolving depending on our needs, so for now it only has two possible
values:
\itemize{
\item \code{crop_product}: The CBS item represents a crop product.
\item \code{other}: Not any of the previous groups.
}
}
}
\source{
Inspired by \href{https://www.fao.org/faostat/en/#data/QCL}{FAOSTAT data}.
}
\usage{
items_prod
}
\description{
Defines name/code correspondences for production items.
}
\keyword{datasets}
