% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_accessibility.R
\name{compare_accessibility}
\alias{compare_accessibility}
\title{Compare Website Accessibility}
\usage{
compare_accessibility(
  input,
  api_key = NULL,
  site_names = NULL,
  plot_type = c("category_counts", "issues", "structure"),
  report_type = 1,
  theme = "light"
)
}
\arguments{
\item{input}{Character vector. URLs to analyze or paths to JSON files}

\item{api_key}{Character string. WAVE API key (required for URL analysis)}

\item{site_names}{Character vector. Optional custom names for sites}

\item{plot_type}{Character string. Type of visualization:
\itemize{
\item "category_counts": Compare main accessibility categories
\item "issues": Detailed breakdown of errors and alerts
\item "structure": Compare structural elements
}}

\item{report_type}{Integer. WAVE report type (1-4)}

\item{theme}{Character string. Visual theme for plot (default: "light")}
}
\value{
ggplot object containing the requested visualization
}
\description{
Main function to generate accessibility comparisons across multiple websites
}
\examples{
\dontrun{
# Compare multiple websites
p <- compare_accessibility(
  input = c("https://example.com", "https://example.org"),
  api_key = "your_api_key",
  plot_type = "category_counts"
)

# Save the plot to a temporary directory
ggsave(file.path(tempdir(), "accessibility_comparison.png"), p)
}
}
