% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_field_consistency.R
\name{assert_field_consistency}
\alias{assert_field_consistency}
\title{Check if the fieldnames of the dataset are the same}
\usage{
assert_field_consistency(new_data, field_info)
}
\arguments{
\item{new_data}{A data frame. The new dataset whose field names need to be checked.}

\item{field_info}{A data frame. Metadata containing a column named \code{raw_field_name} that lists the expected field names.}
}
\value{
No return value. The function issues warnings if there are inconsistencies in field names.
}
\description{
Assert Field Consistency Between Data and Metadata
}
\details{
This function checks for consistency between the field names in new data and the field names specified in a metadata reference.
It warns if there are missing fields in the new data or if new unexpected fields appear in the data that are not defined in the metadata.
}
