% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametersDataframe.R
\name{parametersDataframe}
\alias{parametersDataframe}
\title{Generates a template dataframe to contain simulation parameters.}
\usage{
parametersDataframe(rows=1)
}
\arguments{
\item{rows}{integer, number of rows in the output dataframe.}
}
\value{
A dataframe filled with \code{NA} values and the columns:
\itemize{
  \item \emph{label}: to store names (character string) of the virtual taxa.
  \item \emph{maximum.age}: integer, maximum possible age of the individuals in years.
  \item \emph{reproductive.age}: integer, age of sexual maturity in years.
  \item \emph{fecundity}: integer, number of maximum viable seeds produced by a mature individual under fully suitable conditions.
  \item \emph{growth.rate}: numeric, parameter of the logistic growth function.
  \item \emph{pollen.control}: numeric in the interval [0, 1]. If 0, pollen productivity depends on environmental suitability only. The larger the number, biomass takes over environmental suitability in determining pollen productivity.
  \item \emph{maximum.biomass}: integer, maximum biomass of the individuals.
  \item \emph{carrying.capacity}: integer, maximum sum of biomass of the individuals. Very large carrying capacities plus a low maximum.biomass generates too many individuals for the simulation to remain efficient. Try to set carrying.capacity and maximum.biomass to carrying.capacity divided by biomass returns a number lower than 1000 (and even better if it is closer to 100).
  \item \emph{driver.A.weight}: numeric in the interval [0, 1], represents the relative influence of the driver on environmental suitability.
  \item \emph{driver.B.weight}: numeric in the interval [0, 1], represents the relative influence of the driver on environmental suitability. The sum of weights of drivers A and B should be 1.
  \item \emph{niche.A.mean}: numeric, in the same units as driver A. It is the mean of the normal function defining the response of the virtual taxa to driver A.
  \item \emph{niche.A.sd}: numeric, in the same units as driver A. It is the standard deviation of the normal function defining the response of the virtual taxa to driver A.
  \item \emph{niche.B.mean}: as above, but for driver B.
  \item \emph{niche.B.sd}: as above, but for driver B.
  \item \emph{autocorrelation.length.A}: numeric, only useful if several drivers generated with different autocorrelation lengths are available (and identified by the column \code{autocorrelation.length}) in the \code{drivers} argument provided to the \code{\link{simulatePopulation}} function.
  \item \emph{autocorrelation.length.B}: same as above.
}
}
\description{
Generates the dataframe structure needed to contain the parameters used as input for the \code{\link{simulatePopulation}} function.
}
\details{
The resulting dataframe can either be filled manually through vectors, as shown in the example (but this requires to use the function \code{\link{fixParametersTypes}} once the dataframe is completed), or can be edited manually in Rstudio by installing the \href{https://CRAN.R-project.org/package=editData}{editData} package.
}
\examples{

#generating the template
parameters <- parametersDataframe(rows=1)

#filling it with a vector
parameters[1,] <- c("Species 1", 50, 20, 2, 0.2, 0, 100, 1000, 1, 0, 50, 10, 0, 0, 600, 600)

}
\seealso{
\code{\link{simulatePopulation}}, \code{\link{fixParametersTypes}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
