% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_venn}
\alias{v_venn}
\title{Create a Venn Diagram}
\usage{
v_venn(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  sets_sep = ",",
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{sets_sep}{Sets separator.}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Venn Diagram
}
\examples{

library(vchartr)

# Venn diagram with 2 sets
data.frame(
  sets = c("A", "B", "A,B"),
  value = c(5, 10, 4)
) \%>\% 
  vchart() \%>\% 
  v_venn(aes(sets = sets, value = value))

# with more sets 
data.frame(
  sets = c("A", "B", "C", "A,B", "A,C", "B,C", "A,B,C"),
  value = c(8, 10, 12, 4, 4, 4, 2)
) \%>\% 
  vchart() \%>\% 
  v_venn(aes(sets = sets, value = value))


# More complex example
set.seed(20190708)
genes <- paste("gene",1:1000,sep="")
genes <- list(
  A = sample(genes,300), 
  B = sample(genes,525), 
  C = sample(genes,440),
  D = sample(genes,350)
)

vchart(stack(genes)) \%>\% 
  v_venn(aes(category = ind, values = values))

}
