% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-circlepack.R
\name{position_circlepackdodge}
\alias{position_circlepackdodge}
\title{Arrange over-plotted points with a circle-packing algorithm and dodge groups side-to-side}
\usage{
position_circlepackdodge(width = 1, density = 1, aspect_ratio = 1)
}
\arguments{
\item{width}{The dodging width, which defaults to 1.}

\item{density}{The density of the circle pack, which defaults to 1 but will
have to be adjusted in most cases. The desirable density will depend on both
the ranges of the axes and the dimensions of the image. It will also depend
on the size scale.}

\item{aspect_ratio}{An aspect ratio adjustment to compensate for distortion of the circular arrangement,
which might occur when plotting if coord_equal() is not used. A wide aspect ratio (eg. 2)
would adjust for vertical stretching, whereas a tall aspect ratio (eg. 0.5) would adjust for
horizontal stretching. The default aspect ratio of 1 is appropriate when no adjustment is required.}
}
\value{
A \code{ggproto} object of class \code{PositionCirclePackDodge}.
}
\description{
This function dodges groups and uses a circle packing algorithm from the 'packcircles' package
to arrange perfectly over-plotted points of varying sizes into a elliptical area.
}
\examples{
  library(ggplot2)

  dat <- data.frame(
    X = c(rep(0, 200)),
    Y = rep(0, 200),
    size = runif(200, 0, 1),
    id = (rep(c("A", "B"), 100))
  )

  ggplot(dat, aes(x = X, y = Y, size = size, color = id)) +
    geom_point(position = position_circlepackdodge(width = 1, density = 1, aspect_ratio = 1),
              alpha = 0.25) +
    coord_equal(xlim = c(-1, 1), ylim = c(-1, 1), expand = TRUE) +
    scale_size_continuous(range = c(1, 3)) +
    theme(legend.position = "none")

}
\seealso{
Other Functions: 
\code{\link{position_circlepack}()},
\code{\link{position_jitter_ellipse}()},
\code{\link{position_jitterdodge_ellipse}()},
\code{\link{position_sunflower}()},
\code{\link{position_sunflowerdodge}()},
\code{\link{sunflower}()}
}
\concept{Functions}
