% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_validations.R
\name{check_vaccineff_inputs}
\alias{check_vaccineff_inputs}
\title{Check Correctness of Inputs in \code{make_vaccineff_data}}
\usage{
check_vaccineff_inputs(
  data_set,
  outcome_date_col,
  censoring_date_col,
  vacc_date_col,
  vacc_name_col,
  vaccinated_status,
  unvaccinated_status,
  immunization_delay,
  end_cohort,
  match,
  exact,
  nearest,
  take_first
)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{outcome_date_col}{Name of the column that contains the outcome dates.}

\item{censoring_date_col}{Name of the column that contains the censoring
date. NULL by default.}

\item{vacc_date_col}{Name of the column(s) that contain the vaccine dates.}

\item{vacc_name_col}{Name of the column(s) that contain custom vaccine
names for the vaccines (e.g. brand name, type of vaccine). If provided,
must be of the same length as \code{vacc_date_col}.}

\item{vaccinated_status}{Status assigned to the vaccinated population.
Default is \code{v}.}

\item{unvaccinated_status}{Status assigned to the unvaccinated population.
Default is \code{u}.}

\item{immunization_delay}{Characteristic time in days before the patient
is considered immune. Default is 0.}

\item{end_cohort}{End date of the study.}

\item{match}{\code{TRUE}: cohort matching is performed. Default is \code{FALSE}}

\item{exact}{Name(s) of column(s) for \code{exact} matching. Default is \code{NULL}.}

\item{nearest}{Named vector with name(s) of column(s) for \code{nearest} matching
and caliper(s) for each variable (e.g., \code{nearest = c("characteristic1" = n1, "characteristic2" = n2)}, where \code{n1} and \code{n2} are the calipers). Default is
\code{NULL}.}

\item{take_first}{\code{FALSE}: takes the latest vaccine date. \code{TRUE}: takes the
earliest vaccine date.}
}
\value{
This function does not return a value.
}
\description{
This auxiliary function checks the correctness of the inputs
provided to \code{make_vaccineff_data}.
}
\keyword{internal}
