% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tutorial.R
\name{use_tutorial}
\alias{use_tutorial}
\title{Create a learnr tutorial}
\usage{
use_tutorial(name, title, open = rlang::is_interactive())
}
\arguments{
\item{name}{Base for file name to use for new \code{.Rmd} tutorial. Should consist
only of numbers, letters, \verb{_} and \code{-}. We recommend using lower case.}

\item{title}{The human-facing title of the tutorial.}

\item{open}{Open the newly created file for editing? Happens in RStudio, if
applicable, or via \code{\link[utils:file.edit]{utils::file.edit()}} otherwise.}
}
\description{
Creates a new tutorial below \verb{inst/tutorials/}. Tutorials are interactive R
Markdown documents built with the \href{https://rstudio.github.io/learnr/index.html}{\code{learnr} package}. \code{use_tutorial()} does
this setup:
\itemize{
\item Adds learnr to Suggests in \code{DESCRIPTION}.
\item Gitignores \verb{inst/tutorials/*.html} so you don't accidentally track
rendered tutorials.
\item Creates a new \code{.Rmd} tutorial from a template and, optionally, opens it
for editing.
\item Adds new \code{.Rmd} to \code{.Rbuildignore}.
}
}
\examples{
\dontrun{
use_tutorial("learn-to-do-stuff", "Learn to do stuff")
}
}
\seealso{
The \href{https://rstudio.github.io/learnr/index.html}{learnr package documentation}.
}
