% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{closure_plot_ecdf}
\alias{closure_plot_ecdf}
\title{Visualize CLOSURE data in an ECDF plot}
\usage{
closure_plot_ecdf(
  data,
  samples = c("mean", "all"),
  line_color = "#5D3FD3",
  text_size = 12,
  reference_line_alpha = 0.6,
  pad = TRUE
)
}
\arguments{
\item{data}{List returned by \code{\link[=closure_generate]{closure_generate()}}.}

\item{samples}{String (length 1). How to aggregate the samples? Either draw a
single ECDF line for the average sample (\code{"mean"}, the default); or draw a
separate line for each sample (\code{"all"}). Note: the latter option can be
very slow if many values were found.}

\item{line_color}{String (length 1). Color of the ECDF line. Default is
\code{"#5D3FD3"}, a purple color.}

\item{text_size}{Numeric. Base font size in pt. Default is \code{12}.}

\item{reference_line_alpha}{Numeric (length 1). Opacity of the diagonal
reference line. Default is \code{0.6}.}

\item{pad}{Logical (length 1). Should the ECDF line be padded on the x-axis
so that it stretches beyond the data points? Default is \code{TRUE}.}
}
\value{
A ggplot object.
}
\description{
Call \code{closure_plot_ecdf()} to visualize CLOSURE results using
the data's empirical cumulative distribution function (ECDF).

A diagonal reference line benchmarks the ECDF against a hypothetical linear
relationship.

See \code{\link[=closure_plot_bar]{closure_plot_bar()}} for more intuitive visuals.
}
\details{
The present function was inspired by
\code{\link[rsprite2:plot_distributions]{rsprite2::plot_distributions()}}. However, \code{plot_distributions()} shows
multiple lines because it is based on SPRITE, which draws random samples of
possible datasets. CLOSURE is exhaustive, so \code{closure_plot_ecdf()} shows
all possible datasets in a single line by default.
}
\examples{
# Create CLOSURE data first:
data <- closure_generate(
  mean = "3.5",
  sd = "2",
  n = 52,
  scale_min = 1,
  scale_max = 5
)

# Visualize:
closure_plot_ecdf(data)
}
