% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlparalogis.R
\name{mlparalogis}
\alias{mlparalogis}
\title{Paralogistic distribution maximum likelihood estimation}
\usage{
mlparalogis(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{currently affects nothing.}
}
\value{
\code{mlparalogis} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{shape} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
This function estimates the only the shape parameters of the Paralogistic distribution.
The rate is set to 1.
}
\details{
For the density function of the Paralogistic distribution see \link[actuar:Paralogistic]{Paralogistic}.
}
\examples{
mlparalogis(abalone$length)
}
\references{
Kleiber, C. and Kotz, S. (2003), Statistical Size Distributions in Economics and Actuarial Sciences, Wiley.
Klugman, S. A., Panjer, H. H. and Willmot, G. E. (2012), Loss Models, From Data to Decisions, Fourth Edition, Wiley.
}
\seealso{
\link[actuar:Paralogistic]{Paralogistic} for the paralogistic density.
}
