% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlnbinom.R
\name{mlnbinom}
\alias{mlnbinom}
\title{Negative binomial distribution maximum likelihood estimation}
\usage{
mlnbinom(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{The arguments \code{size} can be specified to only return the ml of \code{prob}.
\code{reltol} is the relative accuracy requested,
defaults to \code{.Machine$double.eps^0.25}. \code{iterlim} is a positive integer
specifying the maximum number of iterations to be performed before the
program is terminated (defaults to \code{100}).}
}
\value{
\code{mlnbinom} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{size} and \code{prob} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
For the density function of the Negative binomial distribution see
\link[stats:NegBinomial]{Negative binomial}.
}
\examples{
mlnbinom(corbet)
}
\references{
Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate Discrete Distributions (3rd ed.). Wiley-Blackwell.
}
\seealso{
\link[stats:NegBinomial]{Negative binomial} for the density.
}
