% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mllogitnorm.R
\name{mllogitnorm}
\alias{mllogitnorm}
\title{Logit-Normal distribution maximum likelihood estimation}
\usage{
mllogitnorm(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{currently affects nothing.}
}
\value{
\code{mllogitnorm} returns an object of \link[base:class]{class}
\code{univariateML}. This is a named numeric vector with maximum likelihood
estimates for \code{mu} and \code{sigma} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
The maximum likelihood estimate of \code{mu} is the empirical mean of the
logit transformed data and the maximum likelihood estimate of
\code{sigma} is the square root of the logit transformed
biased sample variance.
}
\details{
For the density function of the logit-normal distribution see
\link[logitnorm:dlogitnorm]{dlogitnorm}.
}
\examples{
AIC(mllogitnorm(USArrests$Rape / 100))
}
\references{
Atchison, J., & Shen, S. M. (1980). Logistic-normal
distributions: Some properties and uses. Biometrika, 67(2), 261-272.
}
\seealso{
\link[stats:Normal]{Normal} for the normal density.
}
