% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helsinki.R
\docType{data}
\name{helsinki_1}
\alias{helsinki_1}
\title{Main brand colors of the University of Helsinki, Finland}
\format{
An object of class \code{character} of length 5.
}
\source{
New colour definitions should be based on 
the \href{https://www.helsinki.fi}{UH}'s 
\href{https://www.helsinki.fi/en/brand-book/colours}{brand book} (HTML).
}
\usage{
helsinki_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{helsinki_1} provides the brand main colors 
of the \href{https://www.helsinki.fi}{University of Helsinki}, Finland.
}
\details{
To be used in combination with the grayscale colors of \code{\link{helsinki_2}}.

The main colors of Helsinki University style are white, black, 
and shades of blue defined in the brand guide.

\code{helsinki_1} is based on HEX color definitions.
}
\examples{
helsinki_1
unikn::seecol(helsinki_1, 
              main = "Brand main colors of the University of Helsinki, Finland") # view palette

}
\seealso{
\code{\link{helsinki_2}} for grayscale colors of the University of Helsinki;
\code{\link{helsinki_3}} for departmental colors of the University of Helsinki;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Finnish university color palettes: 
\code{\link{aalto_1}},
\code{\link{aalto_2}},
\code{\link{helsinki_2}},
\code{\link{helsinki_3}}
}
\author{
\strong{unicol}, 2023-10-15.
}
\concept{Finnish university color palettes}
\keyword{datasets}
