% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Birmingham.R
\docType{data}
\name{birmingham}
\alias{birmingham}
\title{Colours of the University of Birmingham, England, UK}
\format{
An object of class \code{character} of length 6.
}
\source{
Colour definitions are based on \href{https://www.birmingham.ac.uk/}{UBirmingham}'s 
\href{https://intranet.birmingham.ac.uk/staff/resources/digital/web-resources/editor-resources/guidelines/}{brand guidelines} 
(PDF, revised 2016-02).
}
\usage{
birmingham
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{birmingham} provides the three primary colours 
and two secondary colours 
of the \href{https://www.birmingham.ac.uk/}{University of Birmingham}, England, UK.
}
\details{
The three primary colours are
\code{"Undergraduate"} (defined as HEX #c1d82f),
\code{"Postgraduate"} (defined as HEX #c1d82f),
\code{"MBA"} (defined as HEX #7D0049), and
\code{"Research/Business"} (defined as HEX #605270).

The two secondary colours are 
\code{"Secondary colour 1"} (defined as HEX #bfb6ad), and
\code{"Secondary colour 2"} (defined as HEX #757477).

\code{birmingham} uses the HEX colour definition.
}
\examples{
birmingham
unikn::seecol(birmingham, 
              main = "The colours of the University of Birmingham") # view palette

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing colour palettes;
\code{\link[unikn]{usecol}} for using colour palettes;
\code{\link[unikn]{simcol}} for finding similar colours;
\code{\link[unikn]{newpal}} for defining new colour palettes;
\code{\link[unikn]{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{English university color palettes}
\keyword{datasets}
