% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTwomodeClustering.R
\name{plotTwomodeClustering}
\alias{plotTwomodeClustering}
\title{Plot two-mode clustering results (validation-aware, compact labels)}
\usage{
plotTwomodeClustering(
  myMatrix,
  result,
  title = "",
  xlabel = "",
  ylabel = "",
  varOrder = 0,
  objOrder = 0,
  palette = c("diverging", "viridis", "grey"),
  showBoundaries = TRUE,
  boundaryColor = "white",
  boundarySize = 1,
  showMeans = TRUE,
  fixAspect = TRUE,
  showValidation = TRUE,
  value = c("mean", "standardized", "effectSS"),
  digits = 2,
  sigLevels = c(0.001, 0.01, 0.05, 0.1),
  showMarginal = TRUE,
  labelColor = "white",
  showGlobal = TRUE
)
}
\arguments{
\item{myMatrix}{Numeric matrix or coercible data.frame with the data.}

\item{result}{Result from \code{twomodeClusteringGA()}, with \code{rowClusters}, \code{colClusters},
and optionally \code{validation}.}

\item{title}{Text for title.}

\item{xlabel}{Text for x-axis label.}

\item{ylabel}{Text for y-axis label.}

\item{varOrder}{Order of column clusters (0 = automatic).}

\item{objOrder}{Order of row clusters (0 = automatic).}

\item{palette}{Color scale: "diverging", "viridis", or "grey".}

\item{showBoundaries}{Logical; show cluster boundaries.}

\item{boundaryColor}{Color of the boundaries.}

\item{boundarySize}{Width of the boundaries.}

\item{showMeans}{Logical; show block labels (value + stars if validation).}

\item{fixAspect}{Logical; square cells.}

\item{showValidation}{Logical; use validation information if available.}

\item{value}{Which block statistic to label: "mean", "standardized", or "effectSS".
For "standardized", sign(mean) * sqrt(chi^2_1) is shown if validation is available.}

\item{digits}{Number of decimals in the label.}

\item{sigLevels}{Thresholds for stars: c(0.001, 0.01, 0.05, 0.1).}

\item{showMarginal}{Logical; show "." for p < 0.1.}

\item{labelColor}{Color of the block labels.}

\item{showGlobal}{Logical; add global validation (R2, F, p, p_MC) to subtitle.}
}
\value{
A ggplot object.
}
\description{
Heatmap of the clustered matrix with clear cluster boundaries.
If \code{result$validation} is present, each block shows one label with
the chosen value plus significance stars.
}
\examples{
data("twomodeToy")
myMatrix_s <- scale(twomodeToy)

#Run the GA-based two-mode clustering
result <- twomodeClusteringGA(
  myMatrix = myMatrix_s,
  nRowClusters = 2,
  nColClusters = 3,
  seeds = 1,
  maxiter = 200,
  popSize = 30,
  elitism = 1,
  validate = TRUE,
  verbose = TRUE
)

#Inspect the result
print(result)
summary(result)
myTwomodeResult <- as.data.frame(result)
head(myTwomodeResult)

#Plot the clustered heatmap
plotTwomodeClustering(
  myMatrix = myMatrix_s,
  result   = result,
  title    = "Two-mode clustering Toy example",
  fixAspect = FALSE
)

}
