% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_questions.R
\name{match_questions}
\alias{match_questions}
\title{Match Questions by Pattern}
\usage{
match_questions(x, pattern, ignore.case = TRUE)
}
\arguments{
\item{x}{Either a file path to an HTML file or a tibble with 'id' and 'answer'/'data' columns}

\item{pattern}{A character string to search for in the answers}

\item{ignore.case}{Logical; should the search be case-insensitive? (default: TRUE)}
}
\value{
A character vector of question IDs where the answer contains the pattern
}
\description{
This function takes a single HTML file or tibble and finds all questions/answers
that contain a specified pattern. It returns the question IDs (from the 'id' column)
for rows where the answer contains the pattern.
}
\examples{
\dontrun{
# Search in an HTML file
question_ids <- match_questions("path/to/submission.html", "temperance")
# Returns: c("temperance-16", "temperance-19")

# Search in a tibble

path <- file.path(find.package("tutorial.helpers"), "tests/testthat/fixtures/answers_html")

tibble <- gather_submissions(path, title = "stop")[[1]]

result <- match_questions(tibble, "http")
}
}
