% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_channel_resources.R
\name{list_channel_resources}
\alias{list_channel_resources}
\title{Returns List of Requested Channel Resources}
\usage{
list_channel_resources(
  filter = NULL,
  part = "contentDetails",
  max_results = 50,
  page_token = NULL,
  hl = "en-US",
  ...
)
}
\arguments{
\item{filter}{string; Required.
named vector with a single valid name
potential names of the entry in the vector:
\code{category_id}: YouTube guide category that returns channels associated
with that category
\code{username}:  YouTube username that returns the channel associated with that
 username. Multiple usernames can be provided.
\code{channel_id}: a comma-separated list of the YouTube channel ID(s) for
the resource(s) that are being retrieved}

\item{part}{a comma-separated list of channel resource properties that
response will include a string. Required.
One of the following: \code{auditDetails, brandingSettings, contentDetails,
contentOwnerDetails, id, invideoPromotion, localizations, snippet,
statistics, status, topicDetails}.
Default is \code{contentDetails}.}

\item{max_results}{Maximum number of items that should be returned. Integer.
Optional. Default is 50. Values over 50 will trigger additional requests and
may increase API quota usage.}

\item{page_token}{specific page in the result set that should be returned,
optional}

\item{hl}{Language used for text values. Optional. The default is \code{en-US}.
For other allowed language codes, see \code{\link{list_langs}}.}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
list. If \code{username} is used in \code{filter},
  a data frame with columns \code{username} and \code{channel_id} is returned.
}
\description{
Returns List of Requested Channel Resources
}
\examples{

\dontrun{

# Set API token via yt_oauth() first

list_channel_resources(filter = c(channel_id = "UCT5Cx1l4IS3wHkJXNyuj4TA"))
list_channel_resources(filter = c(username = "latenight"), part = "id")
list_channel_resources(filter = c(username = c("latenight", "PBS")),
                       part = "id")
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/channels/list}
}
