% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{value_at_risk}
\alias{value_at_risk}
\alias{value_at_risk.gogarch.predict}
\alias{value_at_risk.dcc.predict}
\alias{value_at_risk.cgarch.predict}
\alias{value_at_risk.gogarch.simulate}
\alias{value_at_risk.dcc.simulate}
\alias{value_at_risk.cgarch.simulate}
\title{Value at Risk (VaR) method for predicted and simulated objects}
\usage{
value_at_risk(object, ...)

\method{value_at_risk}{gogarch.predict}(object, weights = NULL, alpha = 0.05, ...)

\method{value_at_risk}{dcc.predict}(object, weights = NULL, alpha = 0.05, ...)

\method{value_at_risk}{cgarch.predict}(object, weights = NULL, alpha = 0.05, ...)

\method{value_at_risk}{gogarch.simulate}(object, weights = NULL, alpha = 0.05, ...)

\method{value_at_risk}{dcc.simulate}(object, weights = NULL, alpha = 0.05, ...)

\method{value_at_risk}{cgarch.simulate}(object, weights = NULL, alpha = 0.05, ...)
}
\arguments{
\item{object}{an object generated from the predict or simulate methods.}

\item{...}{not used.}

\item{weights}{a vector of weights of length equal to the number of series. If
NULL then an equal weight vector is used.}

\item{alpha}{the quantile level for the value at risk.}
}
\value{
a matrix of the value at risk. For predict type input objects this will be an xts
matrix with index the forecast dates.
}
\description{
Value at Risk (VaR) method for predicted and simulated objects
}
