% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.cgarch.estimate}
\alias{residuals.cgarch.estimate}
\alias{residuals}
\alias{residuals.dcc.estimate}
\alias{residuals.gogarch.estimate}
\title{Extract Model Residuals}
\usage{
\method{residuals}{cgarch.estimate}(object, standardize = FALSE, type = "standard", ...)

\method{residuals}{dcc.estimate}(object, standardize = FALSE, type = "standard", ...)

\method{residuals}{gogarch.estimate}(object, standardize = FALSE, type = "standard", ...)
}
\arguments{
\item{object}{an object of class \dQuote{cgarch.estimate},
\dQuote{dcc.estimate} or \dQuote{gogarch.estimate}}

\item{standardize}{logical. Whether to standardize the residuals by the
conditional volatility (only valid for the \dQuote{standard} type).}

\item{type}{a choice of \dQuote{standard} (default), \dQuote{model}, or
\dQuote{whitened} residuals. The first choice is the default and represents
the residuals from the first stage univariate GARCH models. The second choice
is only useful for the copula model and represents the residuals from the copula
after the transformation. In the case of the DCC model this will return the
standard type residuals (since they are the same). The last choice represents the
whitened (ZCA based) residuals which are the standard residuals multiplied by the inverse
of the square root of the conditional covariance matrix.}

\item{...}{not currently used.}
}
\value{
An xts matrix.
}
\description{
Extract the residuals of the estimated model.
}
\note{
In the case of the GOGARCH model, the residuals are calculated as
\eqn{\varepsilon  A}, where A is the mixing matrix applied
to the independent component residuals. These will be equal to the residuals
of the original series only if there is no dimensionality reduction.
}
