% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gogarch.R
\name{gogarch_modelspec}
\alias{gogarch_modelspec}
\title{GOGARCH Model specification}
\usage{
gogarch_modelspec(
  y,
  distribution = c("norm", "nig", "gh"),
  model = "garch",
  order = c(1, 1),
  ica = "radical",
  components = NCOL(y),
  lambda_range = c(-5, 5),
  shape_range = c(0.1, 25),
  cond_mean = NULL,
  ...
)
}
\arguments{
\item{y}{an xts matrix of pre-filtered (residuals) stationary data.}

\item{distribution}{a choice for the component distributions. Valid choices are
normal, normal inverse gaussian or generalized hyperbolic distribution.}

\item{model}{the GARCH model to use for each factor.}

\item{order}{the GARCH model order.}

\item{ica}{the Independent Component Analysis algorithm. Current only the
RADICAL algorithm is available.}

\item{components}{the number of components to extract in the pre-whitening
phase,}

\item{lambda_range}{for the generalized hyperbolic distribution, the range of
the lambda parameter.}

\item{shape_range}{for the generalized hyperbolic distribution, the range of
the shape parameter (zeta).}

\item{cond_mean}{an optional matrix of the conditional mean for the series.}

\item{...}{additional arguments passed to the \code{\link{radical}} function.}
}
\value{
an object of class \dQuote{gogarch.spec}.
}
\description{
GOGARCH Model specification
}
