% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_source_model_ar.R
\name{two_source_model_ar}
\alias{two_source_model_ar}
\title{Bayesian model - Two Source Trophic Position with \eqn{\alpha_r}}
\usage{
two_source_model_ar(bp = FALSE, lambda = NULL)
}
\arguments{
\item{bp}{logical value that controls whether informed priors are
supplied to the model for both \eqn{\delta^{15}}N baselines.
Default is \code{FALSE} meaning the model will use uninformed priors, however,
the supplied \code{data.frame} needs values for both \eqn{\delta^{15}}N
baseline (\code{n1} and \code{n2}).}

\item{lambda}{numerical value, \code{1} or \code{2}, that controls whether one or
two lambdas are used. See details for equations and when to use \code{1} or \code{2}.
Defaults to \code{1}.}
}
\value{
returns model structure for two source model to be used in a
\code{brms()} call.
}
\description{
Estimate trophic position using a two source model with \eqn{\alpha_r}
derived from
\href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002} and Heuvel et al.
(2024) \doi{doi:10.1139/cjfas-2024-0028} using a Bayesian framework.
}
\details{
We will use the following equations derived from
\href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002} and Heuvel et al.
(2024) \doi{doi:10.1139/cjfas-2024-0028}:

\enumerate{
\item \deqn{\alpha = (\delta^{13} C_c - \delta ^{13}C_2) /
  (\delta ^{13}C_1 - \delta ^{13}C_2)}

\item \deqn{\alpha = \alpha_r \times (\alpha_{max} - \alpha_{min}) + \alpha_{min}}

\item \deqn{\delta^{15}N = \Delta N \times (tp - \lambda_1) + n_1 \times \alpha_r + n_2 \times (1 - \alpha_r)}

\item \deqn{\delta^{15}N = \Delta N \times (tp - (\lambda_1 \times \alpha_r + \lambda_2 \times (1 - \alpha_r))) + n_1 \times \alpha_r + n_2 \times (1 - \alpha_r)}
}

\strong{For equation 1)}

This equation is a carbon source mixing model with
\eqn{\delta^{13}C_c} is the isotopic value for consumer,
\eqn{\delta^{13}C_1} is the mean isotopic value for baseline 1 and
\eqn{\delta^{13}C_2} is the mean isotopic value for baseline 2. This
equation is added to the data frame using \code{add_alpha()}.

\strong{For equation 2)}

\eqn{\alpha} is being corrected using equations in
Heuvel et al. (2024) \doi{doi:10.1139/cjfas-2024-0028}
with \eqn{\alpha_r} being the corrected value (bound by 0 and 1),
\eqn{\alpha_{min}} is the minimum \eqn{\alpha} value calculated
using \code{add_alpha()} and \eqn{\alpha_{max}} being the maximum \eqn{\alpha}
value calculated using \code{add_alpha()}.

\strong{For equation 3) and 4)}

\eqn{\delta^{15}}N are values from the consumer,
\eqn{n_1} is \eqn{\delta^{15}}N values of baseline 1, \eqn{n_2} is
\eqn{\delta^{15}}N values of baseline 2,
\eqn{\Delta}N is the trophic discrimination factor for N (i.e., mean of \code{3.4}),
tp is trophic position, and  \eqn{\lambda_1} and/or
\eqn{\lambda_2} are the trophic levels of
baselines which are often a primary consumer (e.g., \code{2} or \code{2.5}).

The data supplied to \code{brms()} when using baselines at the same trophic level
(\code{lambda} argument set to \code{1}) needs to have the following variables, \code{d15n},
\code{n1}, \code{n2}, \code{l1} (\eqn{\lambda_1}) which is usually \code{2}. If using baselines at
different trophic levels (\code{lambda} argument set to \code{2}) the data frame needs
to have \code{l1} and \code{l2} with a numerical value for each trophic level (e.g.,
\code{2} and \code{2.5}; \eqn{\lambda_1} and \eqn{\lambda_2}).
}
\examples{
two_source_model_ar()

}
\seealso{
\code{\link[brms:brms-package]{brms::brms()}}
}
