% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cog.R
\name{cog_disp_filter}
\alias{cog_disp_filter}
\title{Helper function for creating a cognostic for a link to another display in a filtered state}
\usage{
cog_disp_filter(
  display,
  var,
  val,
  desc = "link",
  group = "common",
  type = c("href", "href_hash"),
  default_label = FALSE,
  default_active = FALSE,
  filterable = FALSE,
  sortable = FALSE
)
}
\arguments{
\item{display}{A string indicating the name of the display to link to.}

\item{var}{A string indicating the variable name to filter on.}

\item{val}{A string indicating the value of the filter.}

\item{desc}{a description for this cognostic value}

\item{group}{optional categorization of the cognostic for organizational purposes in the viewer (currently not implemented in the viewer)}

\item{type}{of either "href" or "href_hash". "href" will open the link in a new page. "href_hash" will update the page's hash and reload the page (useful when changing state inside an iframe)}

\item{default_label}{should this cognostic be used as a panel label in the viewer by default?}

\item{default_active}{should this cognostic be active (available for sort / filter / sample) by default?}

\item{filterable}{should this cognostic be filterable?  Default is \code{TRUE}.  It can be useful to set this to \code{FALSE} if the cognostic is categorical with many unique values and is only desired to be used as a panel label.}

\item{sortable}{should this cognostic be sortable?}
}
\description{
Helper function for creating a cognostic for a link to another display in a filtered state
}
