% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsimilarity_model.R
\name{rsimilarity_model}
\alias{rsimilarity_model}
\title{Prediction of hydrological similarity to drive transfer of hydrograph to ungauged catchments}
\usage{
rsimilarity_model(
  Rn,
  msim = NULL,
  predictors,
  newpredictors,
  FUN = "invKGE",
  power = 0.5,
  symmetrize = mean,
  model = "glmnet",
  args_glmnet = list(s = "lambda.min", lower.limits = 0),
  standardisation = FALSE,
  first_model = NULL,
  parallel = FALSE,
  cores = NULL,
  verbose = TRUE,
  seed = NULL
)
}
\arguments{
\item{Rn}{net rainfall matrix of gauged catchments (rows for time index, and columns for catchment index)}

\item{msim}{similarity matrix of net rainfall time series (as produced by \link{rsimilarity})}

\item{predictors}{a list of at least two squared matrices that could be used to predict similarity of net rainfall.
The matrices should be squared to describe the similarity of each pair of gauged catchments. High values should
indicate high probability of similarity in net rainfall}

\item{newpredictors}{a matrix or a data.frame of predictors, to be used as new input to the model being built,
and from which we want to predict net rainfall similarity. Typically, a similarity between an ungauged catchment
and several gauged catchments that we want to weight as donors. Each column should correspond to each \code{predictors},
and each row should correspond to each pair of catchments analysed.}

\item{FUN}{either a function or a character string specifying the name of a predifined function to quantify the similarity
of two net rainfall time series. See \link{rsimilarity} for more details}

\item{power}{exponent applied on \code{Rn} time series when computing \code{Rn} similarity (generally between -1 and 1,
a lower value emphasising the similarity of low flows). Default value is 0.5}

\item{symmetrize}{a function to combine \code{FUN(Rn[,i],Rn[,j])} and \code{FUN(Rn[,j],Rn[,i])} into one similarity value
(typically if \code{FUN=KGE}, \code{KGE(Rn[,i],Rn[,j])!=KGE(Rn[,j],Rn[,i])}). Default is mean}

\item{model}{the method to estimate similarity of \code{Rn} from \code{descriptors}. This must be one of "lm", "glmnet"}

\item{args_glmnet}{list of arguments to be passed to \code{glmnet::cv.glmnet()}}

\item{standardisation}{boolean indicating whether the predictors should be standardised
(in particular to make their coefficient comparable)}

\item{first_model}{a first model to use for predicting similarity (generally based on distance, see \code{two_steps} of
\link{mixr}). The actual model will be built on residuals of the first one}

\item{parallel}{logical indicating whether the computation of Rn similarities should be parallelised}

\item{cores}{the number of cores to use for parallel execution if \code{parallel} is TRUE.
If not specified, the number of cores is set to the value of \code{parallel::detectCores()}}

\item{verbose}{boolean indicating if warning messages should be written to the console}

\item{seed}{integer value to be used by \code{set.seed()} for reproducible results. Used only if \code{model="glmnet"}}
}
\description{
Quantify the similarity of net rainfall and model this hydrological similarity from catchment
similarity predictors
}
\examples{
\donttest{data(Oudon)
obs <- as_transfr(st = Oudon$obs, hl = Oudon$hl)
obs <- velocity(obs, method = "loire2016")
obs <- uh(obs)
obs <- lagtime(obs)
obs <- rapriori(obs)
obs <- inversion(obs, parallel = TRUE, cores=2)
mdist1 <- hdist(x = obs, y = obs, method = "rghosh", parallel = c(FALSE,TRUE), cores=2)
mdist2 <- mdist1^2
rghosh1 <- seq(1000, 5000, by=100)
rghosh2 <- rghosh1^2
res <- rsimilarity_model(Rn = obs$st$RnInv,
                   predictors = list(rghosh1=1/mdist1, rghosh2=1/mdist2),
                   newpredictors = data.frame(rghosh1=1/rghosh1, rghosh2=1/rghosh2),
                   seed=1234)
plot(rghosh1, res$similarity, ylab = "Predicted Rn similarity")
plot(rghosh2, res$similarity, ylab = "Predicted Rn similarity")
# rsimilarity_model() is automatically called by mixr() if mdist is a list
obs <- mixr(obs = obs, mdist = mdist1,
            similarity = list(rghosh1=1/mdist1, rghosh2=1/mdist2),
            parallel = TRUE, cores=2, cv = TRUE, save_donor = TRUE)
obs$similarity_models
obs <- convolution(obs)
plot(obs, i = 1, attribute = c("Qobs", "Qsim"))}
}
\seealso{
\link{rsimilarity}, \link{mixr}
}
