% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramicp.R
\name{dicp}
\alias{dicp}
\title{Model-based causal feature selection for general response types}
\usage{
dicp(
  formula,
  data,
  env,
  modFUN,
  verbose = TRUE,
  type = c("residual", "wald", "partial"),
  test = "gcm.test",
  controls = NULL,
  alpha = 0.05,
  baseline_fixed = TRUE,
  greedy = FALSE,
  max_size = NULL,
  mandatory = NULL,
  ...
)
}
\arguments{
\item{formula}{A \code{formula} including response and covariate terms.}

\item{data}{A \code{data.frame} containing response and explanatory variables.}

\item{env}{A \code{formula} specifying the environment variables (see details).}

\item{modFUN}{Model function from 'tram' (or other packages), e.g.,
\code{\link[tram]{BoxCox}}, \code{\link[tram]{Colr}},
\code{\link[tram]{Polr}}, \code{\link[tram]{Lm}},
\code{\link[tram]{Coxph}}, \code{\link[tram]{Survreg}},
\code{\link[tram]{Lehmann}}. Standard implementations
\code{\link[stats]{lm}}, \code{\link[stats]{glm}},
\code{\link[survival]{survreg}}, \code{\link[survival]{coxph}},
and \code{\link[MASS]{polr}} are also supported. See the corresponding
alias \code{<model_name>ICP}, e.g., \code{\link{PolrICP}} or
\code{?implemented_model_classes}. Models from 'lme4', 'tramME',
'glmnet' and 'mgcv' are also supported.}

\item{verbose}{Logical, whether output should be verbose (default \code{TRUE}).}

\item{type}{Character, type of invariance (\code{"residual"} or \code{"wald"});
see \code{Details}.}

\item{test}{Character, specifies the invariance test to be used when
\code{type = "residual"}. The default is \code{"gcm.test"}. Other
implemented tests are \code{"HSIC"}, \code{"t.test"}, \code{"var.test"},
and \code{"combined"}. Alternatively, a custom function for testing
invariance of the form \code{\(r, e, controls) {...}} can be supplied,
which outputs a list with entry \code{"p.value"}.}

\item{controls}{Controls for the used tests and the overall procedure,
see \code{\link{dicp_controls}}.}

\item{alpha}{Level of invariance test, default \code{0.05}.}

\item{baseline_fixed}{Fixed baseline transformation, see
\code{\link[tramicp]{dicp_controls}}.}

\item{greedy}{Logical, whether to perform a greedy version of ICP (default is
\code{FALSE}).}

\item{max_size}{Numeric; maximum support size.}

\item{mandatory}{A \code{formula} containing mandatory covariates, i.e.,
covariates which by domain knowledge are believed to be parents
of the response or are in another way required for the environment or
model to be valid (for instance, conditionally valid environments or
random effects in a mixed model).}

\item{...}{Further arguments passed to \code{modFUN}.}
}
\value{
Object of class \code{"dICP"}, containing
    \itemize{
    \item{\code{candidate_causal_predictors}: Character; intersection of all
    non-rejected sets,}
    \item{\code{set_pvals}: Numeric vector; set-specific p-values of the invariance
    test,}
    \item{\code{predictor_pvals}: Numeric vector; predictor-specific p-values,}
    \item{\code{tests}: List of invariance tests.}
    }
}
\description{
Function `dicp()` implements invariant causal prediction (ICP) for
transformation and generalized linear models, including binary logistic
regression, Weibull regression, the Cox model, linear regression and many
others. The aim of ICP is to discover the direct causes of a response given
data from heterogeneous experimental settings and a potentially large pool of
candidate predictors.
}
\details{
TRAMICP iterates over all subsets of covariates provided in \code{formula}
and performs an invariance test based on the conditional covariance between
score residuals and environments in \code{env} (\code{type = "residual"}) or
the Wald statistic testing for the presence of main and interaction effects
of the environments (\code{type = "wald"}). The algorithm outputs the
intersection over all non-rejected sets as an estimate of the causal parents.
}
\examples{
set.seed(12)
d <- dgp_dicp(n = 1e3, mod = "binary")
dicp(Y ~ X1 + X2 + X3, data = d, env = ~ E, modFUN = "glm",
     family = "binomial", type = "wald")

}
\references{
Kook, L., Saengkyongam, S., Lundborg, A. R., Hothorn, T., & Peters, J. (2023).
Model-based causal feature selection for general response types. arXiv
preprint. \doi{10.48550/arXiv.2309.12833}
}
