% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CommonFunction.R
\name{GroupProb}
\alias{GroupProb}
\title{Membership's probabilities}
\usage{
GroupProb(Obj, Y, A, TCOV = NULL, X = NULL)
}
\arguments{
\item{Obj}{Trajectory's object. A trajectory object that is return by \code{trajeR} function.}

\item{Y}{Matrix. A real matrix. The data.}

\item{A}{Matrix. A real matrix. The time variable.}

\item{TCOV}{Matrix. A real matrix. Optional, by default the value is NULL. It contained the time dependent covariate.}

\item{X}{Matrix. A real matrix. Optional, by default the value is NULL. It contained a covariate that modify the probability membership.}
}
\value{
a real matrix. For each individual i in the data, this matrix contained the membership probability of each group.
}
\description{
\code{GroupProb} calculate the membership probability of each value of the data.
}
\examples{
data <- read.csv(system.file("extdata", "CNORM2gr.csv", package = "trajeR"))
data <- as.matrix(data)
sol <- trajeR(Y = data[, 2:6], A = data[, 7:11], degre = c(2, 2), Model = "CNORM", Method = "EM")
GroupProb(sol, Y = data[, 2:6], A = data[, 7:11])
}
