% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_summary.R
\name{summary.trackeRdata}
\alias{summary.trackeRdata}
\alias{trackeRdataSummary}
\title{Summary of training sessions}
\usage{
\method{summary}{trackeRdata}(
  object,
  session = NULL,
  moving_threshold = NULL,
  unit_reference_sport = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}}.}

\item{session}{A numeric vector of the sessions to be summarised,
defaults to all sessions.}

\item{moving_threshold}{A named vector of 3 speeds above which an
athlete is considered moving, given in the unit of the speed
measurements in \code{object}. If \code{NULL} (default), the
speeds are taken to be \code{c(cycling = 2, running = 1,
swimming = 0.5)}. See Details.}

\item{unit_reference_sport}{The sport to inherit units from
(default is taken to be the most frequent sport in
\code{object}).}

\item{...}{Currently not used.}
}
\value{
An object of class \code{trackeRdataSummary}.
}
\description{
Summary of training sessions
}
\details{
The default speed thresholds are 1 m/s for running (3.6 km/h; slow
walking), 2 m/s for cycling (7.2 km/h) for cycling and 0.5 m/s
(1.8km/h) for swimming. For reference, the preferred walking speed
for humans is around 1.4 m/s (Bohannon, 1997).

The units for the computed summaries match those of the sport
specified by \code{unit_reference_sport}.

If \code{object} has thresholds then the thresholds that match
those of the sport specified by \code{unit_reference_sport} are
applied to the respective summaries.
}
\examples{
data('runs', package = 'trackeR')
runSummary <- summary(runs, session = 1:2)
## print summary
runSummary
print(runSummary, digits = 3)
\dontrun{
## change units
change_units(runSummary, variable = 'speed', unit = 'km_per_h')
## plot summary
runSummaryFull <- summary(runs)
plot(runSummaryFull)
plot(runSummaryFull, group = c('total', 'moving'),
    what = c('avgSpeed', 'distance', 'duration', 'avgHeartRate', "total_elevation_gain"))
}
}
\references{
Bohannon RW (1997). 'Comfortable and Maximum Walking Speed of
Adults Aged 20--79 Years: Reference Values and Determinants.' Age
and Ageing, 26(1), 15--19. doi: 10.1093/ageing/26.1.15.
}
\seealso{
\code{\link{plot.trackeRdataSummary}}
}
