% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_functions.R
\name{extract_fragments}
\alias{extract_fragments}
\title{Extract All Fragments}
\usage{
extract_fragments(fragments_list)
}
\arguments{
\item{fragments_list}{A list of fragments_repeats objects containing fragment data.}
}
\value{
A dataframe containing peak data for each sample
}
\description{
Extracts peak data from each sample in a list of fragments.
}
\examples{
gm_raw <- trace::example_data
metadata <- trace::metadata

test_fragments <- peak_table_to_fragments(gm_raw,
  data_format = "genemapper5",
  dye_channel = "B",
  min_size_bp = 400
)

add_metadata(
  fragments_list = test_fragments,
  metadata_data.frame = metadata
)

find_alleles(
  fragments_list = test_fragments
)

call_repeats(
  fragments_list = test_fragments,
  assay_size_without_repeat = 87,
  repeat_size = 3
)

extract_alleles(test_fragments)

}
