% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showTexts.R
\name{showTexts}
\alias{showTexts}
\title{Exports Readable Text Lists}
\usage{
showTexts(object, id = names(object$text), file, fileEncoding = "UTF-8")
}
\arguments{
\item{object}{\code{\link{textmeta}} object}

\item{id}{Character vector or matrix including article ids}

\item{file}{Character Filename for the export. If not specified the functions output ist only invisible.}

\item{fileEncoding}{character string: declares file encoding. For more information see \code{\link[utils]{write.csv}}}
}
\value{
A list of the requested articles. If file is set, writes a csv including the meta-data of the
requested articles.
}
\description{
Exports the article id, text, title and date.
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

corpus <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

exportedTexts <- showTexts(object=corpus, id = c("A","C"))
}
\keyword{manip}
