% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{profile_likelihood}
\alias{profile_likelihood}
\title{Profile Likelihood Analysis}
\usage{
profile_likelihood(
  param,
  samples,
  grid_size = 40,
  bandwidth_factor = 0.05,
  start_factor = 0.5,
  end_factor = 1.5,
  min_samples = 5
)
}
\arguments{
\item{param}{The character name of the parameter to analyze (e.g., "log_N").}

\item{samples}{A data frame containing parameter samples and a log-likelihoods column named "NLL".}

\item{grid_size}{The integer number of grid points for the analysis.}

\item{bandwidth_factor}{A numeric factor for the local sample window size.}

\item{start_factor, end_factor}{Numeric range multipliers for parameter grid (default: 0.5, 1.2)}

\item{min_samples}{Integer minimum samples required for reliable estimate (default: 10)}
}
\value{
Object of class "profile_likelihood" containing:
\item{param}{Vector of parameter values}
\item{ll}{Vector of log-likelihood values}
\item{param_name}{Name of analyzed parameter}
\item{bandwidth}{Bandwidth used for local windows}
\item{sample_counts}{Number of samples per estimate}
}
\description{
Calculates the profile likelihood for a given parameter by evaluating the conditional
maximum likelihood across a grid of parameter values. This "empirical profile
likelihood" estimates the likelihood surface based on samples from Monte Carlo
simulations.
}
\details{
For each value in the parameter grid, the function:
\enumerate{
\item Identifies nearby samples using a bandwidth window.
\item Calculates the conditional maximum likelihood from these samples.
\item Tracks sample counts to assess the reliability of the estimate.
}
}
\examples{
# Create a sample data frame of parameter samples
mcmc_samples <- data.frame(
  log_N = log(runif(50, 2, 10)),
  log_k0 = log(runif(50, 1, 5)),
  log_cooling_rate = log(runif(50, 0.01, 0.1)),
  log_c_repulsion = log(runif(50, 0.1, 1)),
  NLL = runif(50, 20, 100)
)

# Calculate profile likelihood for the "log_N" parameter
pl <- profile_likelihood("log_N", mcmc_samples,
                         grid_size = 10, # Smaller grid for a quick example
                         bandwidth_factor = 0.05)

# Print the results
print(pl)

}
\seealso{
The S3 methods \code{print.profile_likelihood} and \code{summary.profile_likelihood} for viewing results.
}
