% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genotypic_stability.R
\name{genotypic_stability}
\alias{genotypic_stability}
\title{Genotypic stability}
\usage{
genotypic_stability(data, trait, genotype, environment, unit.correct = FALSE)
}
\arguments{
\item{data}{a dataframe containing trait, genotype and environment.}

\item{trait}{colname of a column containing a numeric vector of interested trait to be analysized.}

\item{genotype}{colname of a column containing a character or factor vector labeling different genotypic varieties}

\item{environment}{colname of a column containing a character or factor vector labeling different environments}

\item{unit.correct}{logical, default is \code{FALSE}, returning the stability index with unit equals to squared unit of trait; when \code{TRUE}, returning stability index with the unit as same as unit of trait.'}
}
\value{
a data table with genotypic stability
}
\description{
\code{genotypic_stability} calculate variance of a genotype across environments.
}
\details{
Genotypic stability (Hanson, 1970) is calculatd based on regression function.
Variety with low stability variance is considered as stable.
Equation of genotypic stability can be found in vignette file.
}
\examples{
data(Data)
genotypic.stability <- genotypic_stability(
 data = Data,
 trait = "Yield",
 genotype = "Genotype",
 environment = "Environment",
 unit.correct = FALSE)
}
\references{
\insertRef{hanson1970}{toolStability}
}
\author{
Tien-Cheng Wang
}
\keyword{approach}
\keyword{regression}
