% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tongfen_ca_estimate.R
\name{tongfen_estimate_ca_census}
\alias{tongfen_estimate_ca_census}
\title{Tongfen estimate data for given geometry}
\usage{
tongfen_estimate_ca_census(
  geometry,
  meta,
  level,
  intersection_level = level,
  downsample_level = NULL,
  na.rm = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{geometry}{geometry}

\item{meta}{metadata for the census variables to aggregate, for example as returned by `meta_for_ca_census_vectors`.
At this point this function only accepts variables from the same census geography year. We will expand this to also
allow estimates across multiple census geography years, but this requires further attention to detail. It is
recommended to apply due caution when running this function separately across several census geography years with
the purpose of comparing data across time as a naive application can lead to systematic biases.}

\item{level}{level to use for tongfen}

\item{intersection_level}{level to use for geometry intersection, if different from tongfen level
by \code{meta_for_ca_census_vectors}. This can be set at a higher aggregation level to conserve API points
for the `get_intersecting_geometries` call.}

\item{downsample_level}{default `NULL`, can be a geographic level lower than `level`, in which case the data is downsamples
to that geography level proportionally using the value of the `downsample` column (must be supplied) in the `meta`
argument before intersecting the geometries. This can lead to more accurate results. At this point the only allowed
variables for the `downsample` column in `meta` are "Population", "Households" or "Dwellings", and it can only be
one of these for all variables.}

\item{na.rm}{how to deal with NA values, default is \code{FALSE}.}

\item{quiet}{suppress progress messages}
}
\description{
\lifecycle{maturing}

Estimates values for the given census vectors for the given geometry using
data from the specified level range. This is a wrapper around `cancensus::get_intersecting_geometries` and `tongfen_estimate`,
optionally with downsampling via `proportional_reaggregate`,
to streamline estimating Canadian census data on custom geographies.
}
\examples{
# Estimate a common geography for 2006 and 2016 dissemination areas in the City of Vancouver
# based on the geographic data and check estimation errors
\dontrun{
toronto_city_hall <- sf::st_point(c(-79.3839,43.6534)) \%>\%
  sf::st_sfc(crs=4326) \%>\%
  sf::st_transform(3348) \%>\%
  sf::st_buffer(1000) \%>\%
  sf::st_sf()

meta <- meta_for_additive_variables("CA16","Population")

data <- tongfen_estimate_ca_census(toronto_city_hall,meta,level="DA",intersection_level="CT")

print(paste0("Approximately ",scales::comma(data$Population,accuracy=100),
             " people live within a 1 km radius of Toronto City."))

}
}
