% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editor-proxy.R
\name{editor_proxy}
\alias{editor_proxy}
\title{Proxy for editor htmlwidget}
\usage{
editor_proxy(shinyId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{shinyId}{single-element character vector indicating the output ID of the
chart to modify (if invoked from a Shiny module, the namespace will be added
automatically).}

\item{session}{the Shiny session object to which the chart belongs; usually the
default value will suffice.}
}
\value{
A \code{editor_proxy} object.
}
\description{
Proxy for editor htmlwidget
}
\examples{
\dontrun{

# Consider having created a editor widget with
editorOutput("my_editor") # UI
output$my_editor <- renderEditor({}) # Server

# Then you can call proxy methods in observer:

# set editor proxy then call a cal_proxy_* function
editor_proxy("my_editor") \%>\%
  cal_proxy_today()

# or directly
cal_proxy_today("my_editor")

}
}
\seealso{
Other editor proxy methods: 
\code{\link{editor-proxy-show-hide}},
\code{\link{editor_proxy_change_preview}()},
\code{\link{editor_proxy_insert}()}
}
\concept{editor proxy methods}
