% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{check_timeseries_gaps}
\alias{check_timeseries_gaps}
\title{Check if there are any gaps in the datetime sequence}
\usage{
check_timeseries_gaps(dtf)
}
\arguments{
\item{dtf}{data.frame or tibble, first column of name \code{datetime} being
of class datetime and rest of columns being numeric}
}
\value{
tibble
}
\description{
This means all rows a part from "datetime" will be NA.
Note that timefully considers a full datetime sequence
when days are complete.
}
\examples{
# Sample just some hours
dtf_gaps <- dtf[c(1:3, 7:10), ]

# Note that the full day is provided
check_timeseries_gaps(
   dtf_gaps
)
}
