% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-type.R
\name{sq_type}
\alias{sq_type}
\alias{sq_type.sq}
\alias{sq_type<-}
\alias{sq_type<-.sq}
\title{Get type of an sq object}
\usage{
sq_type(x, ...)

\method{sq_type}{sq}(x, ...)

sq_type(x) <- value

\method{sq_type}{sq}(x) <- value
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{...}{further arguments to be passed from or to other methods.}

\item{value}{[\code{character(1)}]\cr
The name of destination type - any valid sq type.}
}
\value{
A string, one of: "ami_bsc", "ami_ext", "dna_bsc", "dna_ext",
"rna_bsc", "rna_ext", "unt" or "atp".
}
\description{
Returns type of sequences/alphabet contained in
\code{\link[=sq-class]{sq}} object.
}
\details{
Types returned by this function can be passed as argument to functions like
\code{\link{random_sq}} and \code{\link{find_invalid_letters}}.
}
\examples{
# Creating objects to work on:
sq_ami <- sq(c("MIAANYTWIL","TIAALGNIIYRAIE", "NYERTGHLI", "MAYXXXIALN"),
             alphabet = "ami_ext")
sq_dna <- sq(c("ATGCAGGA", "GACCGAACGA", "TGACGAGCTTA", "ACTTTAGC"),
             alphabet = "dna_bsc")

# Extracting type of sq objects:
sq_type(sq_ami)
sq_type(sq_dna)

# Classes are tightly related to these types:
class(sq_ami)[1]
class(sq_dna)[1]

}
\seealso{
\code{\link[=sq-class]{sq class}}

Functions that manipulate type of sequences:
\code{\link{find_invalid_letters}()},
\code{\link{is.sq}()},
\code{\link{substitute_letters}()},
\code{\link{typify}()}
}
\concept{type_functions}
