% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_perplexity.R
\name{perplexity_chat}
\alias{perplexity_chat}
\title{Send LLM Messages to the Perplexity Chat API (All Features, No .json Option)}
\usage{
perplexity_chat(
  .llm,
  .model = "sonar",
  .max_tokens = 1024,
  .temperature = NULL,
  .top_p = NULL,
  .frequency_penalty = NULL,
  .presence_penalty = NULL,
  .stop = NULL,
  .search_domain_filter = NULL,
  .return_images = FALSE,
  .search_recency_filter = NULL,
  .search_mode = "web",
  .reasoning_effort = NULL,
  .return_related_questions = FALSE,
  .search_after_date_filter = NULL,
  .search_before_date_filter = NULL,
  .last_updated_after_filter = NULL,
  .last_updated_before_filter = NULL,
  .top_k = NULL,
  .web_search_options = NULL,
  .api_url = "https://api.perplexity.ai/",
  .timeout = 60,
  .stream = FALSE,
  .verbose = FALSE,
  .max_tries = 3,
  .dry_run = FALSE
)
}
\arguments{
\item{.llm}{An \code{LLMMessage} object containing the conversation history.}

\item{.model}{Model name to use (default: "sonar").}

\item{.max_tokens}{Max completion tokens (default: 1024).}

\item{.temperature}{Controls response randomness (0 < x < 2).}

\item{.top_p}{Nucleus sampling threshold (0 < x < 1).}

\item{.frequency_penalty}{Number > 0. Penalizes frequent tokens.}

\item{.presence_penalty}{Numeric between -2 and 2. Penalizes present tokens.}

\item{.stop}{Stop sequence(s), string or character vector/list.}

\item{.search_domain_filter}{Domains to allowlist/denylist for search (max 10, "-domain" for denylist).}

\item{.return_images}{Logical; if TRUE, returns images from search.}

\item{.search_recency_filter}{Restrict search to recent ("hour","day","week","month").}

\item{.search_mode}{"web" (default) or "academic" (prioritize scholarly sources).}

\item{.reasoning_effort}{Reasoning level: "low", "medium" (default), "high" (for deep research models).}

\item{.return_related_questions}{Logical; if TRUE, returns related questions.}

\item{.search_after_date_filter}{Only content published after date (mm/dd/yyyy).}

\item{.search_before_date_filter}{Only content published before date (mm/dd/yyyy).}

\item{.last_updated_after_filter}{Only content updated after date (mm/dd/yyyy).}

\item{.last_updated_before_filter}{Only content updated before date (mm/dd/yyyy).}

\item{.top_k}{Top-k token sampling (integer, 0 disables).}

\item{.web_search_options}{Named list with search config (e.g. list(search_context_size = "high")).}

\item{.api_url}{API endpoint (default: "https://api.perplexity.ai/").}

\item{.timeout}{Timeout in seconds (default: 60).}

\item{.stream}{If TRUE, streams response.}

\item{.verbose}{If TRUE, prints additional info.}

\item{.max_tries}{Max request retries (default: 3).}

\item{.dry_run}{If TRUE, returns constructed request instead of sending.}
}
\value{
An updated \code{LLMMessage} object with the assistant's reply and metadata, including citations and search_results.
}
\description{
Sends a chat message history to the Perplexity Chat API, supporting all documented API parameters as of July 2025.
}
