% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyhte-package.R
\docType{package}
\name{tidyhte-package}
\alias{tidyhte}
\alias{tidyhte-package}
\title{tidyhte: Tidy Estimation of Heterogeneous Treatment Effects}
\description{
Estimates heterogeneous treatment effects using tidy semantics on experimental or observational data. Methods are based on the doubly-robust learner of Kennedy (2023) \doi{10.1214/23-EJS2157}. You provide a simple recipe for what machine learning algorithms to use in estimating the nuisance functions and 'tidyhte' will take care of cross-validation, estimation, model selection, diagnostics and construction of relevant quantities of interest about the variability of treatment effects.
}
\details{
The best place to get started with \code{tidyhte} is \code{vignette("experimental_analysis")} which
walks through a full analysis of HTE on simulated data, or \code{vignette("methodological_details")}
which gets into more of the details underlying the method.
}
\references{
Kennedy, E. H. (2020). Towards optimal doubly robust estimation of heterogeneous
causal effects. \emph{arXiv preprint arXiv:2004.14497}.
}
\seealso{
The core public-facing functions are \code{make_splits}, \code{produce_plugin_estimates},
\code{construct_pseudo_outcomes} and \code{estimate_QoI}. Configuration is accomplished through \code{HTE_cfg}
in addition to a variety of related classes (see \code{basic_config}).
}
\author{
\strong{Maintainer}: Drew Dimmery \email{cran@ddimmery.com} (\href{https://orcid.org/0000-0001-9602-6325}{ORCID}) [copyright holder]

}
\keyword{internal}
