% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_cfg.R
\name{Diagnostics_cfg}
\alias{Diagnostics_cfg}
\title{Configuration of Model Diagnostics}
\description{
\code{Diagnostics_cfg} is a configuration class for estimating a variety of
diagnostics for the models trained in the course of HTE estimation.
}
\examples{
Diagnostics_cfg$new(
   outcome = c("SL_risk", "SL_coefs", "MSE", "RROC"),
   ps = c("SL_risk", "SL_coefs", "AUC")
)

## ------------------------------------------------
## Method `Diagnostics_cfg$new`
## ------------------------------------------------

Diagnostics_cfg$new(
   outcome = c("SL_risk", "SL_coefs", "MSE", "RROC"),
   ps = c("SL_risk", "SL_coefs", "AUC")
)

## ------------------------------------------------
## Method `Diagnostics_cfg$add`
## ------------------------------------------------

cfg <- Diagnostics_cfg$new(
   outcome = c("SL_risk", "SL_coefs", "MSE", "RROC"),
   ps = c("SL_risk", "SL_coefs")
)
cfg <- cfg$add(ps = "AUC")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ps}}{Model diagnostics for the propensity score model.}

\item{\code{outcome}}{Model diagnostics for the outcome models.}

\item{\code{effect}}{Model diagnostics for the joint effect model.}

\item{\code{params}}{Parameters for any requested diagnostics.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Diagnostics_cfg-new}{\code{Diagnostics_cfg$new()}}
\item \href{#method-Diagnostics_cfg-add}{\code{Diagnostics_cfg$add()}}
\item \href{#method-Diagnostics_cfg-clone}{\code{Diagnostics_cfg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Diagnostics_cfg-new"></a>}}
\if{latex}{\out{\hypertarget{method-Diagnostics_cfg-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Diagnostics_cfg} object with specified diagnostics to estimate.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Diagnostics_cfg$new(ps = NULL, outcome = NULL, effect = NULL, params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ps}}{Model diagnostics for the propensity score model.}

\item{\code{outcome}}{Model diagnostics for the outcome models.}

\item{\code{effect}}{Model diagnostics for the joint effect model.}

\item{\code{params}}{List providing values for parameters to any requested diagnostics.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Diagnostics_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Diagnostics_cfg$new(
   outcome = c("SL_risk", "SL_coefs", "MSE", "RROC"),
   ps = c("SL_risk", "SL_coefs", "AUC")
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Diagnostics_cfg-add"></a>}}
\if{latex}{\out{\hypertarget{method-Diagnostics_cfg-add}{}}}
\subsection{Method \code{add()}}{
Add diagnostics to the \code{Diagnostics_cfg} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Diagnostics_cfg$add(ps = NULL, outcome = NULL, effect = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ps}}{Model diagnostics for the propensity score model.}

\item{\code{outcome}}{Model diagnostics for the outcome models.}

\item{\code{effect}}{Model diagnostics for the joint effect model.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An updated \code{Diagnostics_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{cfg <- Diagnostics_cfg$new(
   outcome = c("SL_risk", "SL_coefs", "MSE", "RROC"),
   ps = c("SL_risk", "SL_coefs")
)
cfg <- cfg$add(ps = "AUC")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Diagnostics_cfg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Diagnostics_cfg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Diagnostics_cfg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
