% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.robust.R
\name{.fit.robust}
\alias{.fit.robust}
\title{Robust regression for \code{tidyfit}}
\usage{
\method{.fit}{robust}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a robust linear regression on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}
\itemize{
\item \code{method} (estimation algorithm, e.g. 'M', 'MM')
}

The function provides a wrapper for \code{MASS::rlm}. See \code{?rlm} for more details.

\strong{Implementation}``

An argument \code{vcov.} can be passed in control or to \code{...} in \code{\link{m}} to estimate the model with robust standard errors. \code{vcov.} can be one of "BS", "HAC", "HC" and "OPG" and is passed to the \code{sandwich} package.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

fit <- regress(data, Return ~ ., m("robust"), .mask = c("Date", "Industry"))
coef(fit)

# With robust standard errors
fit <- m("robust", Return ~ `Mkt-RF` + HML + SMB, data, vcov. = "HAC")
tidyr::unnest(coef(fit), model_info)

}
\references{
W. N. Venables and B. D. Ripley (2002).
\emph{Modern Applied Statistics with S. 4th ed., Springer, New York.}
URL https://www.stats.ox.ac.uk/pub/MASS4/.\cr
}
\seealso{
\code{\link{.fit.lm}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
