% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.mslm.R
\name{.fit.mslm}
\alias{.fit.mslm}
\title{Markov-Switching Regression for \code{tidyfit}}
\usage{
\method{.fit}{mslm}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a Markov-Switching regression on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}
\itemize{
\item \code{k} (the number of regimes)
\item \code{sw} (logical vector indicating which coefficients switch)
\item \code{control} (additional fitting parameters)
}

The function provides a wrapper for \code{MSwM::msmFit}. See \code{?msmFit} for more details.

\strong{Implementation}

Note that only the regression method with 'lm' is implemented at this stage.

An argument \code{index_col} can be passed, which allows a custom index to be added to \code{coef(m("mslm"))} (e.g. a date index).

If no \code{sw} argument is passed, all coefficients are permitted to switch between regimes.``
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns
data <- dplyr::filter(data, Industry == "HiTec", Date >= 201801)
data <- dplyr::select(data, -Industry)

ctr <- list(maxiter = 100, parallelization = FALSE)

# Stand-alone function
fit <- m("mslm", Return ~ HML, data, index_col = "Date", k = 2, control = ctr)
fit

# Within 'regress' function
fit <- regress(data, Return ~ HML,
               m("mslm", index_col = "Date", k = 2, control = ctr))
tidyr::unnest(coef(fit), model_info)

}
\references{
Sanchez-Espigares JA, Lopez-Moreno A (2021). \emph{MSwM: Fitting Markov Switching Models}. R package version 1.5, \url{https://CRAN.R-project.org/package=MSwM}.
}
\seealso{
\code{\link{.fit.tvp}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
