% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_neighbor_adaptive.R
\name{nearest_neighbor_adaptive}
\alias{nearest_neighbor_adaptive}
\title{Discriminant Adaptive Nearest Neighbor Classification}
\usage{
nearest_neighbor_adaptive(
  mode = "classification",
  neighbors = NULL,
  neighborhood = NULL,
  matrix_diagonal = NULL,
  weighted = NULL,
  sphere = NULL,
  num_comp = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible value for this model is "classification".}

\item{neighbors}{The number of data points used for final classification.}

\item{neighborhood}{The number of data points used to calculate between and
within class covariance.}

\item{matrix_diagonal}{Diagonal elements of a diagonal matrix. 1 is the
identity
matrix.}

\item{weighted}{weighted argument to ncoord. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.
Only sub_dann engine.}

\item{sphere}{One of "mcd", "mve", "classical", or "none" See \code{\link[fpc:ncoord]{fpc::ncoord()}}
for details. Only sub_dann engine.}

\item{num_comp}{Dimension of subspace used by dann. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for
details. Only sub_dann engine.}
}
\value{
An S3 class of type nearest_neighbor_adaptive.
}
\description{
Discriminant Adaptive Nearest Neighbor Classification
}
\details{
Discriminant Adaptive Nearest Neighbor (dann) is a variation of k nearest
neighbors where the shape of the neighborhood is data driven. The
neighborhood is elongated along class boundaries and shrunk in the orthogonal
direction.

This function has engines dann and sub_dann.
}
\examples{

library(parsnip)
library(tidydann)

data("two_class_dat", package = "modeldata")

model <- nearest_neighbor_adaptive(neighbors = 2) |>
  set_engine("dann") |>
  fit(formula = Class ~ A + B, data = two_class_dat)

model |>
  predict(new_data = two_class_dat)

}
