% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wald_test.R
\name{wald_test}
\alias{wald_test}
\title{Wald Test for Linear Hypotheses}
\usage{
wald_test(x, hypothesis, ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{hypothesis}{A character string with equality constrained hypotheses,
specified according to the \code{\link[bain:bain]{bain::bain()}} syntax.}

\item{...}{Additional arguments passed to \code{\link[car:linearHypothesis]{car::linearHypothesis()}}.}
}
\value{
A \code{data.frame} of class \code{wald_test}.
}
\description{
This function is a wrapper for the function
\code{\link[car:linearHypothesis]{car::linearHypothesis()}}, but which uses the \code{\link[bain:bain]{bain::bain()}} syntax to parse
equality constrained hypotheses.
}
\examples{
mod <- lm(Sepal.Length ~ Sepal.Width, data = iris)
coef(mod)
wald_test(mod, "Sepal.Width = 0")
}
\seealso{
\code{\link[car]{linearHypothesis}}
}
