% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{layer_dense_local_reparameterization}
\alias{layer_dense_local_reparameterization}
\title{Densely-connected layer class with local reparameterization estimator.}
\usage{
layer_dense_local_reparameterization(
  object,
  units,
  activation = NULL,
  activity_regularizer = NULL,
  trainable = TRUE,
  kernel_posterior_fn = tfp$layers$util$default_mean_field_normal_fn(),
  kernel_posterior_tensor_fn = function(d) d \%>\% tfd_sample(),
  kernel_prior_fn = tfp$layers$util$default_multivariate_normal_fn,
  kernel_divergence_fn = function(q, p, ignore) tfd_kl_divergence(q, p),
  bias_posterior_fn = tfp$layers$util$default_mean_field_normal_fn(is_singular = TRUE),
  bias_posterior_tensor_fn = function(d) d \%>\% tfd_sample(),
  bias_prior_fn = NULL,
  bias_divergence_fn = function(q, p, ignore) tfd_kl_divergence(q, p),
  ...
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{units}{integer dimensionality of the output space}

\item{activation}{Activation function. Set it to None to maintain a linear activation.}

\item{activity_regularizer}{Regularizer function for the output.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{kernel_posterior_fn}{Function which creates \code{tfd$Distribution} instance representing the surrogate
posterior of the \code{kernel} parameter. Default value: \code{default_mean_field_normal_fn()}.}

\item{kernel_posterior_tensor_fn}{Function which takes a \code{tfd$Distribution} instance and returns a representative
value. Default value: \code{function(d) d \%>\% tfd_sample()}.}

\item{kernel_prior_fn}{Function which creates \code{tfd$Distribution} instance. See \code{default_mean_field_normal_fn} docstring for required
parameter signature. Default value: \code{tfd_normal(loc = 0, scale = 1)}.}

\item{kernel_divergence_fn}{Function which takes the surrogate posterior distribution, prior distribution and random variate
sample(s) from the surrogate posterior and computes or approximates the KL divergence. The
distributions are \code{tfd$Distribution}-like instances and the sample is a \code{Tensor}.}

\item{bias_posterior_fn}{Function which creates a \code{tfd$Distribution} instance representing the surrogate
posterior of the \code{bias} parameter. Default value:  \code{default_mean_field_normal_fn(is_singular = TRUE)} (which creates an
instance of \code{tfd_deterministic}).}

\item{bias_posterior_tensor_fn}{Function which takes a \code{tfd$Distribution} instance and returns a representative
value. Default value: \code{function(d) d \%>\% tfd_sample()}.}

\item{bias_prior_fn}{Function which creates \code{tfd} instance. See \code{default_mean_field_normal_fn} docstring for required parameter
signature. Default value: \code{NULL} (no prior, no variational inference)}

\item{bias_divergence_fn}{Function which takes the surrogate posterior distribution, prior distribution and random variate sample(s)
from the surrogate posterior and computes or approximates the KL divergence. The
distributions are \code{tfd$Distribution}-like instances and the sample is a \code{Tensor}.}

\item{...}{Additional keyword arguments passed to the \code{keras::layer_dense} constructed by this layer.}
}
\value{
a Keras layer
}
\description{
This layer implements the Bayesian variational inference analogue to
a dense layer by assuming the \code{kernel} and/or the \code{bias} are drawn
from distributions.
}
\details{
By default, the layer implements a stochastic
forward pass via sampling from the kernel and bias posteriors,

\if{html}{\out{<div class="sourceCode">}}\preformatted{kernel, bias ~ posterior
outputs = activation(matmul(inputs, kernel) + bias)
}\if{html}{\out{</div>}}

It uses the local reparameterization estimator (Kingma et al., 2015),
which performs a Monte Carlo approximation of the distribution on the hidden
units induced by the \code{kernel} and \code{bias}. The default \code{kernel_posterior_fn}
is a normal distribution which factorizes across all elements of the weight
matrix and bias vector. Unlike that paper's multiplicative parameterization, this
distribution has trainable location and scale parameters which is known as
an additive noise parameterization (Molchanov et al., 2017).

The arguments permit separate specification of the surrogate posterior
(\code{q(W|x)}), prior (\code{p(W)}), and divergence for both the \code{kernel} and \code{bias}
distributions.

Upon being built, this layer adds losses (accessible via the \code{losses}
property) representing the divergences of \code{kernel} and/or \code{bias} surrogate
posteriors and their respective priors. When doing minibatch stochastic
optimization, make sure to scale this loss such that it is applied just once
per epoch (e.g. if \code{kl} is the sum of \code{losses} for each element of the batch,
you should pass \code{kl / num_examples_per_epoch} to your optimizer).
You can access the \code{kernel} and/or \code{bias} posterior and prior distributions
after the layer is built via the \code{kernel_posterior}, \code{kernel_prior},
\code{bias_posterior} and \code{bias_prior} properties.
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1506.02557}{Diederik Kingma, Tim Salimans, and Max Welling. Variational Dropout and the Local Reparameterization Trick. In \emph{Neural Information Processing Systems}, 2015.}
\item \href{https://arxiv.org/abs/1701.05369}{Dmitry Molchanov, Arsenii Ashukha, Dmitry Vetrov. Variational Dropout Sparsifies Deep Neural Networks. In \emph{International Conference on Machine Learning}, 2017.}
}
}

\seealso{
Other layers: 
\code{\link{layer_autoregressive}()},
\code{\link{layer_conv_1d_flipout}()},
\code{\link{layer_conv_1d_reparameterization}()},
\code{\link{layer_conv_2d_flipout}()},
\code{\link{layer_conv_2d_reparameterization}()},
\code{\link{layer_conv_3d_flipout}()},
\code{\link{layer_conv_3d_reparameterization}()},
\code{\link{layer_dense_flipout}()},
\code{\link{layer_dense_reparameterization}()},
\code{\link{layer_dense_variational}()},
\code{\link{layer_variable}()}
}
\concept{layers}
