% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_gui.R
\name{analyze_code_combinations}
\alias{analyze_code_combinations}
\title{Analyze combinations of code pairs}
\usage{
analyze_code_combinations(overlaps)
}
\arguments{
\item{overlaps}{List of overlap information, where each element contains:
\itemize{
\item code1: character, identifier of first code
\item code2: character, identifier of second code
}}
}
\value{
List containing:
\itemize{
\item frequencies: Table object containing counts of each code pair combination,
where row names are formatted as "code1-code2" with codes sorted alphabetically
}
}
\description{
Analyzes the frequency of different code combinations by counting how often
different pairs of codes appear together in overlapping annotations.
}
\details{
The function processes overlapping code pairs and creates a frequency table of their
combinations. Code pairs are sorted alphabetically before counting to ensure consistent
ordering (e.g., "A-B" and "B-A" are counted as the same combination). Returns an empty
list if no overlaps are provided.
}
\keyword{internal}
