% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.durational.R
\name{is.durational}
\alias{is.durational}
\alias{is.durational.NULL}
\alias{is.durational.ergm_model}
\alias{is.durational.ergm_state}
\alias{is.durational.formula}
\title{Testing for duration dependent models}
\usage{
is.durational(object, ...)

\method{is.durational}{`NULL`}(object, ...)

\method{is.durational}{ergm_model}(object, ...)

\method{is.durational}{ergm_state}(object, ...)

\method{is.durational}{formula}(object, response = NULL, basis = ergm.getnetwork(object), ...)
}
\arguments{
\item{object}{An ERGM formula, \code{\link[ergm:ergm_model]{ergm_model}} object, or
\code{\link[ergm:ergm_state]{ergm_state}} object.}

\item{\dots}{Unused at this time.}

\item{response, basis}{See \code{\link[ergm:ergm]{ergm()}}.}
}
\value{
\code{TRUE} if the ERGM terms in the model are duration dependent;
\code{FALSE} otherwise.
}
\description{
These functions test whether an ERGM is duration dependent or not.

The method for \code{NULL} always returns \code{FALSE} by
convention.
}
\section{Methods (by class)}{
\itemize{
\item \code{is.durational(ergm_model)}: Test if the \code{\link[ergm:ergm_model]{ergm_model}} has duration-dependent terms, which call for \code{\link{lasttoggle}} data structures.

\item \code{is.durational(ergm_state)}: Test if the \code{\link[ergm:ergm_state]{ergm_state}} has duration-dependent terms, which call for \code{\link{lasttoggle}} data structures.

}}
\keyword{model}
