% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eager.R
\name{tf_function}
\alias{tf_function}
\title{Creates a callable TensorFlow graph from an R function.}
\usage{
tf_function(f, input_signature = NULL, autograph = TRUE, ...)
}
\arguments{
\item{f}{the function to be compiled}

\item{input_signature}{A possibly nested sequence of \code{tf$TensorSpec} objects
specifying the shapes and dtypes of the tensors that will be supplied to
this function. If \code{NULL}, a separate function is instantiated for each
inferred input signature. If \code{input_signature} is specified, every input to
\code{f} must be a tensor.}

\item{autograph}{TRUE or FALSE. If TRUE (the default), you can use tensors in
R control flow expressions \code{if}, \code{while}, \code{for} and \code{break} and they will
be traced into the tensorflow graph. A guide to getting started and
additional details can be found:
\href{https://t-kalinowski.github.io/tfautograph/}{here}}

\item{...}{additional arguments passed on to \code{tf.function} (vary based on
Tensorflow version). See
\href{https://www.tensorflow.org/api_docs/python/tf/function#args_1}{here} for
details.}
}
\description{
\code{tf_function} constructs a callable that executes a TensorFlow graph created
by tracing the TensorFlow operations in \code{f}. This allows the TensorFlow
runtime to apply optimizations and exploit parallelism in the computation
defined by \code{f}.
}
\details{
A guide to getting started with
\href{https://www.tensorflow.org/api_docs/python/tf/function}{\code{tf.function}} can
be found \href{https://www.tensorflow.org/guide/function}{here}.
}
